/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Chamelion
extends EntityLiving {
    public Chamelion(World w) {
        super(w);
        this.maxrenderdist = 60;
        this.height = 0.75f;
        this.width = 0.55f;
        this.uniquename = "OreSpawn:Chameleon";
        this.moveSpeed = 0.15f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 45;
        this.setExperience(5);
        this.setCanDespawn(false);
        this.canSwim = true;
        this.enableHostility(14.0f, 3.5f);
        this.temperament = 2;
        this.enableTaming(14);
        this.enableFollowHeldFood(12);
        this.enableDroppedFood(12);
    }

    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e.getWidth() * e.getHeight() > 0.063f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophychamelion.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Chameliontexture.png");
        }
        return this.texture;
    }
}

